import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/application/providers.dart';
import 'package:admin_desktop/domain/models/models.dart';
import 'package:admin_desktop/infrastructure/constants/constants.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import '../../../../../../../../app_constants.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../riverpod/service_master/edit/edit_service_master_provider.dart';
import '../riverpod/service_master/service_master_provider.dart';
import '../widgets/services_modal.dart';

class EditServiceMasterPage extends ConsumerStatefulWidget {
  const EditServiceMasterPage({super.key});

  @override
  ConsumerState<EditServiceMasterPage> createState() => _EditLooksPageState();
}

class _EditLooksPageState extends ConsumerState<EditServiceMasterPage> {
  final _formKey = GlobalKey<FormState>();
  late TextEditingController commission;
  late TextEditingController pause;
  late TextEditingController price;
  late TextEditingController master;
  late TextEditingController interval;
  late TextEditingController service;
  late TextEditingController discount;
  UserData? selectMaster;
  ServiceData? selectService;

  @override
  void initState() {
    final ServiceData? serviceData =
        ref.read(editServiceMasterProvider).serviceData;
    commission =
        TextEditingController(text: "${serviceData?.commissionFee ?? ''}");
    pause = TextEditingController(text: "${serviceData?.pause ?? 0}");
    price = TextEditingController(text: "${serviceData?.price ?? 0}");
    interval = TextEditingController(text: "${serviceData?.interval ?? ''}");
    discount = TextEditingController(text: "${serviceData?.discount ?? 0}");
    master =
        TextEditingController(text: "${serviceData?.master?.firstname ?? 0}");
    service = TextEditingController(
        text: "${serviceData?.service?.translation?.title ?? 0}");
    //  discount=TextEditingController(text: "${serviceData?. ?? 0}");
    selectMaster = serviceData?.master;
    selectService = serviceData?.service;
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => ref.read(editServiceMasterProvider.notifier).fetchServiceDetails(
          context: context,
          id: ref.read(editServiceMasterProvider).serviceData?.id,
          onSuccess: (ServiceData? value) {
            selectMaster = value?.master;
            selectService = value?.service;
            master.text = value?.master?.firstname ?? '';
          }),
    );
  }

  @override
  void dispose() {
    commission.dispose();
    pause.dispose();
    price.dispose();
    interval.dispose();
    master.dispose();
    service.dispose();
    discount.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(editServiceMasterProvider);
    final notifier = ref.read(editServiceMasterProvider.notifier);
    return KeyboardDisable(
      child: Container(
          padding: EdgeInsets.symmetric(horizontal: 16,vertical: 12),
          constraints: BoxConstraints(
            maxHeight: state.isLoading
                ? 300
                : MediaQuery.of(context).size.height / 1.2,
            maxWidth: 600,
          ),
          decoration: BoxDecoration(
              color: Style.white,
              borderRadius: BorderRadius.circular(AppConstants.radius)),
          child: state.serviceData == null || state.isLoading
              ? const Loading()
              : Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    Row(
                      children: [
                        BackButton(
                          onPressed: () {
                            Navigator.pop(context);
                            // ref.read(catalogueProvider.notifier).changeState(3);
                          },
                        ),
                        20.horizontalSpace,
                        Text(
                          AppHelpers.getTranslation(TrKeys.editService),
                          style: Style.interMedium(size: 20),
                        ),
                      ],
                    ),
                    Form(
                      key: _formKey,
                      child: SingleChildScrollView(
                        child: Column(
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            16.verticalSpace,
                            Row(
                              children: [
                                Expanded(
                                  child: OutlinedBorderTextField(
                                    readOnly: true,
                                    onTap: () {
                                      AppHelpers.showAlertDialog(
                                        backgroundColor: Style.white,
                                        context: context,
                                        child: SizedBox(
                                          width: 200,
                                          child: ServicesModal(
                                            onChange: (value) {
                                              selectService = value;
                                              service.text =
                                                  value.translation?.title ??
                                                      '';
                                              interval.text =
                                                  "${value.interval ?? 0}";
                                              pause.text =
                                                  "${value.pause ?? 0}";
                                              price.text =
                                                  "${value.price ?? 0}";
                                            },
                                          ),
                                        ),
                                      );
                                    },
                                    label:
                                        "${AppHelpers.getTranslation(TrKeys.service)}*",
                                    textInputAction: TextInputAction.next,
                                    validator: AppValidators.emptyCheck,
                                    textController: service,
                                  ),
                                ),
                                12.horizontalSpace,
                                Expanded(
                                  child: OutlinedBorderTextField(
                                    label:
                                        '${AppHelpers.getTranslation(TrKeys.interval)}*',
                                    textInputAction: TextInputAction.next,
                                    textController: interval,
                                    inputType: TextInputType.number,
                                    validator: AppValidators.isNumberValidator,
                                    inputFormatters: [
                                      InputFormatter.digitsOnly
                                    ],
                                  ),
                                ),
                              ],
                            ),
                            16.verticalSpace,
                            Row(
                              children: [
                                Expanded(
                                  child: OutlinedBorderTextField(
                                    label:
                                        '${AppHelpers.getTranslation(TrKeys.pause)}*',
                                    textInputAction: TextInputAction.next,
                                    inputType: TextInputType.number,
                                    textController: pause,
                                    validator: AppValidators.isNumberValidator,
                                    inputFormatters: [
                                      InputFormatter.digitsOnly
                                    ],
                                  ),
                                ),
                                12.horizontalSpace,
                                Expanded(
                                  child: OutlinedBorderTextField(
                                    label:
                                        '${AppHelpers.getTranslation(TrKeys.price)}*',
                                    textInputAction: TextInputAction.next,
                                    textController: price,
                                    inputType: TextInputType.number,
                                    validator: AppValidators.emptyCheck,
                                    inputFormatters: [InputFormatter.currency],
                                  ),
                                ),
                              ],
                            ),
                            16.verticalSpace,
                            Row(
                              children: [
                                Expanded(
                                  child: OutlinedBorderTextField(
                                    label: AppHelpers.getTranslation(
                                        TrKeys.commissionFee),
                                    textInputAction: TextInputAction.done,
                                    textController: commission,
                                    inputType: TextInputType.number,
                                    inputFormatters: [InputFormatter.currency],
                                  ),
                                ),
                                12.horizontalSpace,
                                Expanded(
                                  child: OutlineDropDown(
                                    label: TrKeys.gender,
                                    list: DropDownValues.genderList,
                                    onChanged: notifier.setGender,
                                    value: state.serviceData?.gender,
                                  ),
                                ),
                              ],
                            ),
                            56.verticalSpace,
                            CustomButton(
                              textColor: Style.white,
                              title: AppHelpers.getTranslation(TrKeys.save),
                              isLoading: state.isUpdating,
                              onTap: () {
                                if ((_formKey.currentState?.validate() ??
                                        false) &&
                                    ref
                                            .watch(editMastersProvider)
                                            .masterData
                                            ?.id !=
                                        null) {
                                  notifier.updateService(
                                    context,
                                    updated: (service) {
                                      AppHelpers.showSnackBar(
                                        context,
                                        AppHelpers.getTranslation(
                                            TrKeys.successfullyUpdated),
                                      );
                                      ref
                                          .read(serviceMasterProvider.notifier)
                                          .fetchServices(
                                              context: context,
                                              isRefresh: true,
                                              masterId: ref
                                                  .watch(editMastersProvider)
                                                  .masterData
                                                  ?.id);
                                      Navigator.pop(context);
                                      // ref.read(catalogueProvider.notifier).changeState(3);
                                    },
                                    discount: discount.text,
                                    price: price.text,
                                    interval: interval.text,
                                    pause: pause.text,
                                    serviceId: selectService!.id!,
                                    masterId: ref
                                            .watch(editMastersProvider)
                                            .masterData
                                            ?.id ??
                                        0,
                                    commissionFee: commission.text,
                                  );
                                }
                              },
                            ),
                            12.verticalSpace,
                          ],
                        ),
                      ),
                    ),
                  ],
                )),
    );
  }
}
